/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.api.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import squeek.appleskin.api.food.FoodValues;

@Cancelable
public class HUDOverlayEvent
extends Event {
    public int x;
    public int y;
    public PoseStack matrixStack;

    private HUDOverlayEvent(int x, int y, PoseStack matrixStack) {
        this.x = x;
        this.y = y;
        this.matrixStack = matrixStack;
    }

    public boolean isCancelable() {
        return true;
    }

    public static class HealthRestored
    extends HUDOverlayEvent {
        public final FoodValues foodValues;
        public final ItemStack itemStack;
        public final float modifiedHealth;

        public HealthRestored(float modifiedHealth, ItemStack itemStack, FoodValues foodValues, int x, int y, PoseStack matrixStack) {
            super(x, y, matrixStack);
            this.modifiedHealth = modifiedHealth;
            this.itemStack = itemStack;
            this.foodValues = foodValues;
        }
    }

    public static class HungerRestored
    extends HUDOverlayEvent {
        public final FoodValues foodValues;
        public final ItemStack itemStack;
        public final int currentFoodLevel;

        public HungerRestored(int foodLevel, ItemStack itemStack, FoodValues foodValues, int x, int y, PoseStack matrixStack) {
            super(x, y, matrixStack);
            this.currentFoodLevel = foodLevel;
            this.itemStack = itemStack;
            this.foodValues = foodValues;
        }
    }

    public static class Saturation
    extends HUDOverlayEvent {
        public final float saturationLevel;

        public Saturation(float saturationLevel, int x, int y, PoseStack matrixStack) {
            super(x, y, matrixStack);
            this.saturationLevel = saturationLevel;
        }
    }

    public static class Exhaustion
    extends HUDOverlayEvent {
        public final float exhaustion;

        public Exhaustion(float exhaustion, int x, int y, PoseStack matrixStack) {
            super(x, y, matrixStack);
            this.exhaustion = exhaustion;
        }
    }
}

